/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class AdvancedGraphicsChip
extends GraphicsChip {
    protected int[] frameBuffer;
    protected int[] scaledBuffer;
    protected int[] transparentImage = new int[0];
    protected int[][] tileImage;
    protected boolean[] tileReadState;
    protected int[] tempPix;
    protected int windowSourceLine;

    public AdvancedGraphicsChip(Dmgcpu d) {
        super(d);
        this.colors = new int[]{-2131166984, -2136430424, -2142220208, Integer.MIN_VALUE};
        this.gbcMask = Integer.MIN_VALUE;
        this.transparentCutoff = this.cpu.gbcFeatures ? 32 : 4;
        this.tileImage = new int[this.tileCount * this.colorCount][];
        this.tileReadState = new boolean[this.tileCount];
        this.tempPix = new int[64];
        this.frameBuffer = new int[23040];
    }

    public final void addressWrite(int addr, byte data) {
        int tileIndex;
        if (this.videoRam[addr] == data) {
            return;
        }
        if (addr < 6144 && this.tileReadState[tileIndex = (addr >> 4) + this.tileOffset]) {
            int r = this.tileImage.length - this.tileCount + tileIndex;
            do {
                this.tileImage[r] = null;
            } while ((r -= this.tileCount) >= 0);
            this.tileReadState[tileIndex] = false;
        }
        this.videoRam[addr] = data;
    }

    public final void invalidateAll(int pal) {
        int start = pal * this.tileCount * 4;
        int stop = (pal + 1) * this.tileCount * 4;
        for (int r = start; r < stop; ++r) {
            this.tileImage[r] = null;
        }
    }

    protected final void drawSpritesForLine(int line) {
        int priorityFlag;
        if (!this.spritesEnabled) {
            return;
        }
        int minSpriteY = this.doubledSprites ? line - 15 : line - 7;
        int n = priorityFlag = this.spritePriorityEnabled ? 128 : 0;
        while (priorityFlag >= 0) {
            int oamIx = 159;
            while (oamIx >= 0) {
                int attributes;
                if (((attributes = 0xFF & this.cpu.oam[oamIx--]) & 0x80) == priorityFlag || !this.spritePriorityEnabled) {
                    int tileNum = 0xFF & this.cpu.oam[oamIx--];
                    int spriteX = (0xFF & this.cpu.oam[oamIx--]) - 8;
                    int spriteY = (0xFF & this.cpu.oam[oamIx--]) - 16;
                    int offset = line - spriteY;
                    if (spriteX >= 160 || spriteY < minSpriteY || offset < 0) continue;
                    if (this.doubledSprites) {
                        tileNum &= 0xFE;
                    }
                    int spriteAttrib = attributes >> 5 & 3;
                    if (this.cpu.gbcFeatures) {
                        spriteAttrib += 32 + ((attributes & 7) << 2);
                        tileNum += 48 * (attributes & 8);
                    } else {
                        spriteAttrib += 4 + ((attributes & 0x10) >> 2);
                    }
                    if (priorityFlag == 128) {
                        if (this.doubledSprites) {
                            if ((spriteAttrib & 2) != 0) {
                                this.drawPartBgSprite((tileNum | 1) - (offset >> 3), spriteX, line, offset & 7, spriteAttrib);
                                continue;
                            }
                            this.drawPartBgSprite((tileNum & 0xFFFFFFFE) + (offset >> 3), spriteX, line, offset & 7, spriteAttrib);
                            continue;
                        }
                        this.drawPartBgSprite(tileNum, spriteX, line, offset, spriteAttrib);
                        continue;
                    }
                    if (this.doubledSprites) {
                        if ((spriteAttrib & 2) != 0) {
                            this.drawPartFgSprite((tileNum | 1) - (offset >> 3), spriteX, line, offset & 7, spriteAttrib);
                            continue;
                        }
                        this.drawPartFgSprite((tileNum & 0xFFFFFFFE) + (offset >> 3), spriteX, line, offset & 7, spriteAttrib);
                        continue;
                    }
                    this.drawPartFgSprite(tileNum, spriteX, line, offset, spriteAttrib);
                    continue;
                }
                oamIx -= 3;
            }
            priorityFlag -= 128;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean drawBackgroundForLine(int line, int windowLeft, int priority) {
        int tileNum;
        int screenX;
        boolean skippedTile = false;
        int sourceY = line + (this.cpu.registers[66] & 0xFF);
        int sourceImageLine = sourceY & 7;
        int tileX = (this.cpu.registers[67] & 0xFF) >> 3;
        int memStart = (this.hiBgTileMapAddress ? 7168 : 6144) + ((sourceY & 0xF8) << 2);
        for (screenX = -(this.cpu.registers[67] & 7); screenX < windowLeft; ++tileX, screenX += 8) {
            tileNum = this.bgWindowDataSelect ? this.videoRamBanks[0][memStart + (tileX & 0x1F)] & 0xFF : 256 + this.videoRamBanks[0][memStart + (tileX & 0x1F)];
            int tileAttrib = 0;
            if (this.cpu.gbcFeatures) {
                byte mapAttrib = this.videoRamBanks[1][memStart + (tileX & 0x1F)];
                if ((mapAttrib & 0x80) != priority) {
                    skippedTile = true;
                    continue;
                }
                tileAttrib += (mapAttrib & 7) << 2;
                tileAttrib += mapAttrib >> 5 & 3;
                tileNum += 384 * (mapAttrib >> 3 & 1);
            }
            this.drawPartCopy(tileNum, screenX, line, sourceImageLine, tileAttrib);
        }
        if (windowLeft < 160) {
            int windowStartAddress = this.hiWinTileMapAddress ? 7168 : 6144;
            int windowSourceTileY = this.windowSourceLine >> 3;
            int windowSourceTileLine = this.windowSourceLine & 7;
            int tileAddress = windowStartAddress + windowSourceTileY * 32;
            for (screenX = windowLeft; screenX < 160; ++tileAddress, screenX += 8) {
                tileNum = this.bgWindowDataSelect ? this.videoRamBanks[0][tileAddress] & 0xFF : 256 + this.videoRamBanks[0][tileAddress];
                int tileAttrib = 0;
                if (this.cpu.gbcFeatures) {
                    byte mapAttrib = this.videoRamBanks[1][tileAddress];
                    if ((mapAttrib & 0x80) != priority) {
                        skippedTile = true;
                        continue;
                    }
                    tileAttrib += (mapAttrib & 7) << 2;
                    tileAttrib += mapAttrib >> 5 & 3;
                    tileNum += 384 * (mapAttrib >> 3 & 1);
                }
                this.drawPartCopy(tileNum, screenX, line, windowSourceTileLine, tileAttrib);
            }
        }
        return skippedTile;
    }

    public final void notifyScanline(int line) {
        int windowLeft;
        if (this.skipping || line >= 144) {
            return;
        }
        if (line == 0) {
            this.windowSourceLine = 0;
        }
        if (this.winEnabled && (this.cpu.registers[74] & 0xFF) <= line) {
            windowLeft = (this.cpu.registers[75] & 0xFF) - 7;
            if (windowLeft > 160) {
                windowLeft = 160;
            }
        } else {
            windowLeft = 160;
        }
        boolean skippedAnything = this.drawBackgroundForLine(line, windowLeft, 0);
        this.drawSpritesForLine(line);
        if (skippedAnything) {
            this.drawBackgroundForLine(line, windowLeft, 128);
        }
        if (windowLeft < 160) {
            ++this.windowSourceLine;
        }
        if (line == 143) {
            this.updateFrameBufferImage();
        }
    }

    protected final void updateFrameBufferImage() {
        if (!this.lcdEnabled) {
            int[] buffer = this.scale ? this.scaledBuffer : this.frameBuffer;
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = -1;
            }
            this.frameBufferImage = Image.createRGBImage((int[])buffer, (int)this.scaledWidth, (int)this.scaledHeight, (boolean)false);
            return;
        }
        if (this.scale) {
            if (MeBoy.scalingMode == 0) {
                int deltaX = 163839 / this.scaledWidth;
                int deltaY = 147455 / this.scaledHeight;
                int sy = 0;
                int ry = deltaY >> 1;
                int dst = 0;
                int dstStop = this.scaledWidth;
                for (int y = 0; y < this.scaledHeight; ++y) {
                    int rx = deltaX >> 1;
                    int src = sy * 160;
                    while (dst < dstStop) {
                        this.scaledBuffer[dst++] = this.frameBuffer[src];
                        rx = (rx & 0x3FF) + deltaX;
                        src += rx >> 10;
                    }
                    ry = (ry & 0x3FF) + deltaY;
                    sy += ry >> 10;
                    dstStop += this.scaledWidth;
                }
            } else if (MeBoy.scalingMode == 1) {
                int deltaX = 162815 / this.scaledWidth;
                int deltaY = 147455 / this.scaledHeight;
                int sy = 0;
                int ry = deltaY >> 1;
                int dst = 0;
                int dstStop = this.scaledWidth;
                for (int y = 0; y < this.scaledHeight; ++y) {
                    int rx = deltaX >> 1;
                    int src = sy * 160;
                    while (dst < dstStop) {
                        int rightPart = rx >> 7;
                        int leftPart = 8 - rightPart;
                        this.scaledBuffer[dst++] = leftPart * this.frameBuffer[src] + rightPart * this.frameBuffer[src + 1] >> 3;
                        src += (rx += deltaX) >> 10;
                        rx &= 0x3FF;
                    }
                    ry = (ry & 0x3FF) + deltaY;
                    sy += ry >> 10;
                    dstStop += this.scaledWidth;
                }
            } else if (MeBoy.scalingMode == 2) {
                int deltaX = 163839 / this.scaledWidth;
                int deltaY = 146431 / this.scaledHeight;
                int sy = 0;
                int ry = deltaY >> 1;
                int dst = 0;
                int dstStop = this.scaledWidth;
                for (int y = 0; y < this.scaledHeight; ++y) {
                    int rx = deltaX >> 1;
                    int src = sy * 160;
                    while (dst < dstStop) {
                        int bottomPart = ry >> 7;
                        int topPart = 8 - bottomPart;
                        this.scaledBuffer[dst++] = topPart * this.frameBuffer[src] + bottomPart * this.frameBuffer[src + 160] >> 3;
                        src += (rx += deltaX) >> 10;
                        rx &= 0x3FF;
                    }
                    sy += (ry += deltaY) >> 10;
                    ry &= 0x3FF;
                    dstStop += this.scaledWidth;
                }
            } else if (MeBoy.scalingMode == 3) {
                int deltaX = 162815 / this.scaledWidth;
                int deltaY = 146431 / this.scaledHeight;
                int sy = 0;
                int ry = deltaY >> 1;
                int dst = 0;
                int dstStop = this.scaledWidth;
                for (int y = 0; y < this.scaledHeight; ++y) {
                    int bottomPart = ry >> 7;
                    int topPart = 8 - bottomPart;
                    int rx = deltaX >> 1;
                    int src = sy * 160;
                    while (dst < dstStop) {
                        int topRightPart = rx * topPart >> 10;
                        int topLeftPart = topPart - topRightPart;
                        int bottomRightPart = rx * bottomPart >> 10;
                        int bottomLeftPart = bottomPart - bottomRightPart;
                        this.scaledBuffer[dst++] = topLeftPart * this.frameBuffer[src] + topRightPart * this.frameBuffer[src + 1] + bottomLeftPart * this.frameBuffer[src + 160] + bottomRightPart * this.frameBuffer[src + 161] >> 3;
                        src += (rx += deltaX) >> 10;
                        rx &= 0x3FF;
                    }
                    sy += (ry += deltaY) >> 10;
                    ry &= 0x3FF;
                    dstStop += this.scaledWidth;
                }
            }
            this.frameBufferImage = Image.createRGBImage((int[])this.scaledBuffer, (int)this.scaledWidth, (int)this.scaledHeight, (boolean)false);
        } else {
            this.frameBufferImage = Image.createRGBImage((int[])this.frameBuffer, (int)160, (int)144, (boolean)false);
        }
    }

    protected final int[] updateImage(int tileIndex, int attribs) {
        int index = tileIndex + this.tileCount * attribs;
        boolean otherBank = tileIndex >= 384;
        int offset = otherBank ? tileIndex - 384 << 4 : tileIndex << 4;
        int paletteStart = attribs & 0xFC;
        byte[] vram = otherBank ? this.videoRamBanks[1] : this.videoRamBanks[0];
        int[] palette = this.cpu.gbcFeatures ? this.gbcPalette : this.gbPalette;
        boolean transparent = attribs >= this.transparentCutoff;
        int pixix = 0;
        int pixixdx = 1;
        int pixixdy = 0;
        if ((attribs & 2) != 0) {
            pixixdy = -16;
            pixix = 56;
        }
        if ((attribs & 1) == 0) {
            pixixdx = -1;
            pixix += 7;
            pixixdy += 16;
        }
        int y = 8;
        while (--y >= 0) {
            int num;
            if ((num = weaveLookup[vram[offset++] & 0xFF] + (weaveLookup[vram[offset++] & 0xFF] << 1)) != 0) {
                transparent = false;
            }
            int x = 8;
            while (--x >= 0) {
                this.tempPix[pixix] = palette[paletteStart + (num & 3)];
                pixix += pixixdx;
                num >>= 2;
            }
            pixix += pixixdy;
        }
        if (transparent) {
            this.tileImage[index] = this.transparentImage;
        } else {
            this.tileImage[index] = this.tempPix;
            this.tempPix = new int[64];
        }
        this.tileReadState[tileIndex] = true;
        return this.tileImage[index];
    }

    protected final void drawPartCopy(int tileIndex, int x, int y, int sourceLine, int attribs) {
        int dstEnd;
        int ix = tileIndex + this.tileCount * attribs;
        int[] im = this.tileImage[ix];
        if (im == null) {
            im = this.updateImage(tileIndex, attribs);
        }
        int dst = x + y * 160;
        int src = sourceLine * 8;
        int n = dstEnd = x + 8 > 160 ? (y + 1) * 160 : dst + 8;
        if (x < 0) {
            dst -= x;
            src -= x;
        }
        while (dst < dstEnd) {
            this.frameBuffer[dst++] = im[src++];
        }
    }

    protected final void drawPartFgSprite(int tileIndex, int x, int y, int sourceLine, int attribs) {
        int dstEnd;
        int ix = tileIndex + this.tileCount * attribs;
        int[] im = this.tileImage[ix];
        if (im == null) {
            im = this.updateImage(tileIndex, attribs);
        }
        if (im == this.transparentImage) {
            return;
        }
        int dst = x + y * 160;
        int src = sourceLine * 8;
        int n = dstEnd = x + 8 > 160 ? (y + 1) * 160 : dst + 8;
        if (x < 0) {
            dst -= x;
            src -= x;
        }
        while (dst < dstEnd) {
            if (im[src] < 0) {
                this.frameBuffer[dst] = im[src];
            }
            ++dst;
            ++src;
        }
    }

    protected final void drawPartBgSprite(int tileIndex, int x, int y, int sourceLine, int attribs) {
        int dstEnd;
        int ix = tileIndex + this.tileCount * attribs;
        int[] im = this.tileImage[ix];
        if (im == null) {
            im = this.updateImage(tileIndex, attribs);
        }
        if (im == this.transparentImage) {
            return;
        }
        int dst = x + y * 160;
        int src = sourceLine * 8;
        int n = dstEnd = x + 8 > 160 ? (y + 1) * 160 : dst + 8;
        if (x < 0) {
            dst -= x;
            src -= x;
        }
        while (dst < dstEnd) {
            if (im[src] < 0 && this.frameBuffer[dst] >= 0) {
                this.frameBuffer[dst] = im[src];
            }
            ++dst;
            ++src;
        }
    }

    public void setScale(int screenWidth, int screenHeight) {
        if (MeBoy.keepProportions) {
            if (screenWidth * 18 > screenHeight * 20) {
                screenWidth = screenHeight * 20 / 18;
            } else {
                screenHeight = screenWidth * 18 / 20;
            }
        }
        if (screenWidth == this.scaledWidth && screenHeight == this.scaledHeight) {
            return;
        }
        this.scale = screenWidth != 160 || screenHeight != 144;
        this.scaledWidth = screenWidth;
        this.scaledHeight = screenHeight;
        this.scaledBuffer = (int[])(this.scale ? new int[this.scaledWidth * this.scaledHeight] : null);
    }

    public void setGBCPalette(int index, int data) {
        super.setGBCPalette(index, data);
        if ((index & 6) == 0) {
            int n = index >> 1;
            this.gbcPalette[n] = this.gbcPalette[n] & 0xFFFFFF;
        }
    }
}

